import NextAuth from "next-auth";
import CredentialsProvider from "next-auth/providers/credentials";

const authOptions = {
    providers: [
        CredentialsProvider({
            name: 'Credentials',
            async authorize(credentials, req) {
                try {
                    const url = process.env.NEXT_PUBLIC_API_URL + '/login';
                    const formData = new URLSearchParams();
                    formData.append('email', credentials.email);
                    formData.append('password', credentials.password);
                    const res = await fetch(url, {
                        method: "POST",
                        headers: {
                            "Accept": "application/json"
                        },
                        body: formData
                    });
                    const data = await res.json();

                    if (res.ok && data.status == 'success') {
                        const loggeinUser = {
                            token: data.authorization.token,
                            name: data.user.name
                        }
                        return loggeinUser
                    } else {
                        throw new Error(data.message || 'Invalid email or password');
                    }
                } catch (error) {
                    throw new Error(error.message || 'An error occurred during sign-in');
                }
            }
        })
    ],

    callbacks: {
        async jwt({ token, user }) {
            if (user) {
                return { ...token, ...user };
            }
            return token;
        },
        async session({ session, token }) {
            session.user = {
                token: token.token,
                name: token.name,
            }
            return session;
        }
    },

    pages: {
        signIn: '/login',
        signOut: '/login',
        error: '/login',
        newUser: '/register',
    }
}

const handler = NextAuth(authOptions);

export { handler as GET, handler as POST }